<%@ Control Language="C#" Inherits="System.Web.Mvc.ViewUserControl" %>

<% Ajax.RegisterClientScriptInclude(Url.Content("~/Content/Scripts/jquery-1.3.2.min.js"), "http://ajax.Microsoft.com/ajax/jQuery/jquery-1.3.2.min.js"); %>
<% Ajax.RegisterClientScriptInclude(Url.Content("~/Content/Scripts/MicrosoftAjax.js"), "http://ajax.Microsoft.com/ajax/beta/0909/MicrosoftAjax.js"); %>
<% Ajax.RegisterClientScriptInclude(Url.Content("~/Content/Scripts/MicrosoftAjaxTemplates.js"), "http://ajax.Microsoft.com/ajax/beta/0909/MicrosoftAjaxTemplates.js"); %>
<% Ajax.RegisterCombinedScriptInclude(Url.Content("~/Content/Scripts/jquery-ui-1.7.2.custom.js"), "pmn"); %>
<% Ajax.RegisterCombinedScriptInclude(Url.Content("~/Content/Scripts/jquery.simulate.js"), "pmn"); %>
<% Ajax.RegisterCombinedScriptInclude(Url.Content("~/Content/Scripts/jquery.autocomplete.min.js"), "pmn"); %>
<% Ajax.RegisterCombinedScriptInclude(Url.Content("~/Content/Scripts/ajax.common.js"), "pmn"); %>
<% Ajax.RegisterCombinedScriptInclude(Url.Content("~/Content/Scripts/ajax.search.js"), "pmn"); %>

<%-- SearchResults Panel --%>

<div id="searchResultsDynamic" class="panel searchResults" style="display:none">
    <div class="innerPanel">
        <h2>
            <ul>
                <li class="linkActivities">
                    <strong>Activities</strong>
                    <a href="#" class="searchTypeItinerary">Itineraries</a>
                </li>
                <li class="linkItineraries">
                    <a href="#" class="searchTypeActivity">Activities</a>
                    <strong >Itineraries</strong>
                </li>
                <li class="linkActivityItineraries flex">
                    <strong><a href="/">Go Back</a> Itineraries for '<span></span>'</strong>
                </li>
            </ul>
        </h2>
        
        <div id="resultsTemplateContainer">
            <div class="items loading"></div>
            <div class="toolbox"></div>
        </div>
    </div>
</div>

<%-- Templates --%>
<div style="display:none" id="templates">

    <%-- Activities template --%>
    <div id="dynamicActivitiesResults" style="display:none;">
        <div id="dynamicActivitiesSort" class="sys-template subheader">
            <span sys:if="$dataItem.orderBy!='Distance'">
            Sort by:
                <strong sys:if="$dataItem.orderBy=='Relevance'">Relevance</strong>
                <a sys:if="$dataItem.orderBy!='Relevance'" sys:href="{binding null, convert=sortByConverter, defaultValue=Relevance}">Relevance</a>
                |
                <strong sys:if="$dataItem.orderBy=='Rating'">Rating</strong>
                <a sys:if="$dataItem.orderBy!='Rating'" sys:href="{binding null, convert=sortByConverter, defaultValue=Rating}">Rating</a>
                |
                <strong sys:if="$dataItem.orderBy=='Popularity'">Popularity</strong>
                <a sys:if="$dataItem.orderBy!='Popularity'" sys:href="{binding null, convert=sortByConverter, defaultValue=Popularity}">Popularity</a>
            </span>
        </div>
        <div class="items">
            <h3 id="dynamicActivitiesEmpty" style="display:none">No activities found...</h3>
            <ul id="dynamicActivitiesItems"  class="sys-template activities" >
                <li>
                    <span class="off id">{{Entity.Id}}</span>
                    <h3>
                        <span class="rating"><span>Rating: </span>{binding Entity.Rating, convert=activityRatingConverter}</span>
                        <a sys:href="{{DetailsLink}}">{{Entity.Name}}</a>
                    </h3>
                    <p>{{Entity.Street}}</p>
                    <p>{{Entity.City}}, {{Entity.State}} | Phone: {{Entity.PhoneNumber}}</p>
                    <p class="options">
                        <a sys:href="{{ActivityItinerariesLink}}" class="btn relatedItineraries">Itineraries containing this activity</a>
                        <a sys:href="{{AddToItineraryLink}}" class="btn add">Add to Itinerary</a>
                        <span style="display:none" class="handler">Drag to Add</span>
                    </p>
                </li>
            </ul>
        </div>
        <div class="toolbox">
            <div class="pager">
                <span id="dynamicActivitiesPager" class="sys-template">
                    <span sys:if="$dataItem.PreviousPageLink==null"> Previous</span>
                    <a sys:if="$dataItem.PreviousPageLink!=null" sys:href="{{PreviousPageLink}}" class="ajaxSearch"> Previous</a>
                    | <strong>Page {{CurrentPage}}</strong> |
                    <span sys:if="$dataItem.NextPageLink==null">Next </span>
                    <a sys:if="$dataItem.NextPageLink!=null" sys:href="{{NextPageLink}}" class="ajaxSearch">Next </a>
                </span>
            </div>
        </div>
    </div>

    <%-- Itineraries template --%>
    <div id="dynamicItinerariesResults" style="display:none;">
        <div class="items">
            <h3 id="dynamicItinerariesEmpty" style="display:none">No itineraries found...</h3>
            <ul id="dynamicItinerariesItems" class="sys-template itineraries" >
                <li>
                    <span class="off id">{{Id}}</span>
                    <h3>
                        <span class="rating"><span>Rating: </span>{binding Rating, convert=itineraryRatingConverter}</span>
                        <a sys:href="{{DetailsLink}}">{{Name}}</a>
                    </h3>
                    <p>
                        <span style="float: right; font-size: .75em">Created on <span>{binding Created, convert=dateConverter}</span></span>
                        <span sys:if="$dataItem.Description!=null">{{Description}}<br /></span>
                        <span sys:if="$dataItem.EstimatedMinutes!=0">Estimated time: <span>{binding EstimatedMinutes, convert=friendlyTimeConverter}</span><br /></span>
                    </p>
                    <p class="children">
                        <a sys:href="{{DetailsLink}}" class="toggleActivities">View Activities ({{ActivitiesCount}})</a>
                        <a sys:href="{{AddActivitiesLink}}" class="bulkAdd ajax" style="display:none">Add activities to my itinerary</a>
                    </p>
                </li>
            </ul>
        </div>
        <div class="toolbox">
            <div class="pager">
                <span id="dynamicItinerariesPager" class="sys-template">
                    <span sys:if="$dataItem.PreviousPageLink==null"> Previous</span>
                    <a sys:if="$dataItem.PreviousPageLink!=null" sys:href="{{PreviousPageLink}}" class="ajaxSearch"> Previous</a>
                    | <strong>Page {{CurrentPage}}</strong> |
                    <span sys:if="$dataItem.NextPageLink==null">Next </span>
                    <a sys:if="$dataItem.NextPageLink!=null" sys:href="{{NextPageLink}}" class="ajaxSearch">Next </a>
                </span>
            </div>
        </div>
    </div>

    <ul id="itineraryActivitiesTemplate" class="sys-template activities">
        <li>
            <span class="off id">{{Entity.Id}}</span>
            <h3>
                <span class="rating"><span>Rating: </span>{binding Entity.Rating, convert=activityRatingConverter}</span>
                {{Entity.Name}}
            </h3>
            <p>{{Entity.Street}}</p>
            <p>{{Entity.City}}, {{Entity.State}} | Phone: {{Entity.PhoneNumber}}</p>
            <p class="options">
                <a sys:href="{{AddToItineraryLink}}" class="btn add">Add to Itinerary</a>
                <span style="display:none" class="handler">Drag to Add</span>
            </p>
        </li>
    </ul>
    
    <!-- error template -->
    <div id="errorTemplate" class="sys-template ajaxError">
        <div class="items">
            <h3>Ooops!<br />An error occurred.</h3>
            <p>Want to <a class="retry" sys:href="{{RetryUrl}}">try again?</a></p>
            <p class="details" sys:if="$dataItem.Details!=''">{{Details}}</p>
        </div>
        <div class="toolbox"></div>
    </div>

</div>

<%--Drag and Drop container --%>
<ul id="temporalActivities" class="activities" style="text-align:left"></ul>
